/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.player.display;

import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimBox;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.player.ClientBlockDisplayTracker;
import io.github.flemmli97.flan.player.PlayerClaimData;
import io.github.flemmli97.flan.player.display.DisplayBox;
import io.github.flemmli97.flan.player.display.EnumDisplayType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2596;
import net.minecraft.class_2675;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4076;
import org.jetbrains.annotations.NotNull;

public class ClaimDisplay {
    private int displayTime;
    private final int displayHeight;
    private final DisplayBox display;
    public final EnumDisplayType type;
    private DisplayBoxPos pos;
    private ClaimBox prevDims;
    private final UUID displayId = UUID.randomUUID();

    public ClaimDisplay(Claim claim, EnumDisplayType type, int y) {
        this(claim.display(), (class_1937)claim.getLevel(), type, y);
    }

    public ClaimDisplay(DisplayBox display, class_1937 level, EnumDisplayType type, int y) {
        this.display = display;
        this.displayTime = ConfigHandler.CONFIG.claimDisplayTime;
        this.type = type;
        this.displayHeight = Math.max(1 + level.method_31607(), y);
    }

    private static DisplayBoxPos calculatePos(class_3218 level, DisplayBox display, int height) {
        boolean is3d = display.is3d();
        ChunkCache chunkCache = new ChunkCache(level);
        ClaimBox box = display.box();
        List<class_2338> vertices = ClaimDisplay.boxVertices(box, is3d);
        List<class_2338> edges = ClaimDisplay.boxEdges(box, display.excludedSides(), is3d, height, vertices, chunkCache);
        if (!is3d) {
            ArrayList<class_2338> verticesNew = new ArrayList<class_2338>();
            for (class_2338 pos : vertices) {
                Height heightPos = ClaimDisplay.getHeight(pos.method_10263(), pos.method_10260(), height, chunkCache);
                if (heightPos == null) continue;
                if (heightPos.solid != heightPos.water) {
                    verticesNew.add(new class_2338(box.minX(), heightPos.water, box.minZ()));
                }
                verticesNew.add(new class_2338(box.minX(), heightPos.solid, box.minZ()));
            }
            vertices = verticesNew;
        }
        return new DisplayBoxPos(vertices, edges);
    }

    private static List<class_2338> boxVertices(ClaimBox box, boolean is3d) {
        ArrayList<class_2338> vertices = new ArrayList<class_2338>();
        if (is3d) {
            vertices.add(new class_2338(box.minX(), box.minY(), box.minZ()));
            vertices.add(new class_2338(box.maxX(), box.minY(), box.minZ()));
            vertices.add(new class_2338(box.maxX(), box.minY(), box.maxZ()));
            vertices.add(new class_2338(box.minX(), box.minY(), box.maxZ()));
            vertices.add(new class_2338(box.minX(), box.maxY(), box.minZ()));
            vertices.add(new class_2338(box.maxX(), box.maxY(), box.minZ()));
            vertices.add(new class_2338(box.maxX(), box.maxY(), box.maxZ()));
            vertices.add(new class_2338(box.minX(), box.maxY(), box.maxZ()));
        } else {
            vertices.add(new class_2338(box.minX(), 0, box.minZ()));
            vertices.add(new class_2338(box.maxX(), 0, box.minZ()));
            vertices.add(new class_2338(box.maxX(), 0, box.maxZ()));
            vertices.add(new class_2338(box.minX(), 0, box.maxZ()));
        }
        return vertices;
    }

    private static List<class_2338> boxEdges(ClaimBox box, Set<class_2350> exclude, boolean is3d, int height, List<class_2338> vertices, ChunkCache chunkCache) {
        ArrayList<class_2338> edges = new ArrayList<class_2338>();
        if (is3d) {
            for (int i = 0; i < 4; ++i) {
                int next = (i + 1) % 4;
                int upperNext = (i + 1) % 4 + 4;
                class_2338 now = vertices.get(i);
                class_2338 nowUpper = vertices.get(i + 4);
                class_2338 nextPos = vertices.get(next);
                class_2338 nextPosUpper = vertices.get(upperNext);
                ClaimDisplay.interpolateEvenly(now, nextPos, true, 10, edges::add);
                ClaimDisplay.interpolateEvenly(nowUpper, nextPosUpper, true, 10, edges::add);
                ClaimDisplay.interpolateEvenly(now, nowUpper, true, 10, edges::add);
            }
        } else {
            Consumer<class_2338> cons = pos -> {
                Height calc = ClaimDisplay.getHeight(pos.method_10263(), pos.method_10260(), height, chunkCache);
                if (calc != null) {
                    if (calc.solid != calc.water) {
                        edges.add(new class_2338(pos.method_10263(), calc.water, pos.method_10260()));
                    }
                    edges.add(new class_2338(pos.method_10263(), calc.solid, pos.method_10260()));
                }
            };
            for (int i = 0; i < 4; ++i) {
                int next = (i + 1) % 4;
                class_2338 now = vertices.get(i);
                class_2338 nextPos = vertices.get(next);
                if (!exclude.contains(class_2350.field_11043) && now.method_10260() == nextPos.method_10260() && now.method_10260() == box.minZ()) {
                    ClaimDisplay.interpolateEvenly(now, nextPos, false, 10, cons);
                }
                if (!exclude.contains(class_2350.field_11035) && now.method_10260() == nextPos.method_10260() && now.method_10260() == box.maxZ()) {
                    ClaimDisplay.interpolateEvenly(now, nextPos, false, 10, cons);
                }
                if (!exclude.contains(class_2350.field_11039) && now.method_10263() == nextPos.method_10263() && now.method_10263() == box.minX()) {
                    ClaimDisplay.interpolateEvenly(now, nextPos, false, 10, cons);
                }
                if (exclude.contains(class_2350.field_11034) || now.method_10263() != nextPos.method_10263() || now.method_10263() != box.maxX()) continue;
                ClaimDisplay.interpolateEvenly(now, nextPos, false, 10, cons);
            }
        }
        return edges;
    }

    private static void interpolateEvenly(@NotNull class_2338 start, class_2338 end, boolean height, int step, Consumer<class_2338> cons) {
        int dist;
        class_2338.class_2339 startM = start.method_25503();
        class_2338.class_2339 endM = end.method_25503();
        int dX = Integer.compare(endM.method_10263() - startM.method_10263(), 0);
        int dY = Integer.compare(height ? endM.method_10264() - startM.method_10264() : 0, 0);
        int dZ = Integer.compare(endM.method_10260() - startM.method_10260(), 0);
        startM.method_10100(dX, dY, dZ);
        endM.method_10100(-dX, -dY, -dZ);
        cons.accept(startM.method_10062());
        cons.accept(endM.method_10062());
        if (startM.method_19455((class_2382)endM) < step) {
            return;
        }
        while ((dist = height ? startM.method_19455((class_2382)endM) : ClaimDisplay.dist2d((class_2382)startM, (class_2382)endM)) > step) {
            int amount = (int)Math.min((double)step, (double)dist * 0.5);
            startM.method_10100(dX * amount, dY * amount, dZ * amount);
            endM.method_10100(-dX * amount, -dY * amount, -dZ * amount);
            cons.accept(startM.method_10062());
            cons.accept(endM.method_10062());
            if (dist >= startM.method_19455((class_2382)endM) && amount >= step) continue;
            break;
        }
    }

    private static int dist2d(class_2382 first, class_2382 sec) {
        int dX = Math.abs(sec.method_10263() - first.method_10263());
        int dZ = Math.abs(sec.method_10260() - first.method_10260());
        return dX + dZ;
    }

    public boolean display(class_3222 player, boolean remove) {
        if (--this.displayTime % 2 == 0) {
            return this.display.isRemoved();
        }
        ClaimBox dims = this.display.box();
        if (this.pos == null || this.changed(dims)) {
            this.pos = ClaimDisplay.calculatePos(player.method_51469(), this.display, this.displayHeight);
            if (!ConfigHandler.CONFIG.particleDisplay) {
                PlayerClaimData data = PlayerClaimData.get(player);
                HashSet<ClientBlockDisplayTracker.DisplayData> displayData = new HashSet<ClientBlockDisplayTracker.DisplayData>();
                for (class_2338 pos : this.pos.vertices) {
                    displayData.add(new ClientBlockDisplayTracker.DisplayData(pos, this.type.displayBlock));
                }
                for (class_2338 pos : this.pos.edges) {
                    displayData.add(new ClientBlockDisplayTracker.DisplayData(pos, this.type.displayBlock));
                }
                data.clientBlockDisplayTracker.displayFakeBlocks(this.displayId, displayData);
            }
        }
        if (ConfigHandler.CONFIG.particleDisplay) {
            for (class_2338 pos : this.pos.vertices) {
                player.field_13987.method_14364((class_2596)new class_2675(this.type.cornerParticle, true, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5 + player.method_51469().method_8409().method_43058() * 1.5, (double)pos.method_10260() + 0.5, 0.0f, 1.0f, 0.0f, 1.0f, 0));
            }
            for (class_2338 pos : this.pos.edges) {
                player.field_13987.method_14364((class_2596)new class_2675(this.type.middleParticle, true, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5 + player.method_51469().method_8409().method_43058() * 1.5, (double)pos.method_10260() + 0.5, 0.0f, 1.0f, 0.0f, 1.0f, 0));
            }
        }
        this.prevDims = dims;
        return this.display.isRemoved() || remove && this.displayTime < 0;
    }

    public void onRemoved(class_3222 player) {
        if (!ConfigHandler.CONFIG.particleDisplay) {
            PlayerClaimData data = PlayerClaimData.get(player);
            data.clientBlockDisplayTracker.resetFakeBlocks(this.displayId);
        }
    }

    private boolean changed(ClaimBox dims) {
        return this.prevDims == null || !this.prevDims.equals(dims);
    }

    public static Height getHeight(int x, int z, int y, ChunkCache chunkCache) {
        class_2818 chunk = chunkCache.fetchChunk(x, z);
        if (chunk == null) {
            return null;
        }
        class_2338.class_2339 pos = new class_2338.class_2339(x, y, z);
        class_2680 state = chunk.method_8320((class_2338)pos);
        if (state.method_45474()) {
            boolean startedInLiquid = state.method_51176();
            boolean inLiquid = false;
            int liquidHeight = pos.method_10264();
            while (state.method_45474() && !chunk.method_31606((class_2338)pos)) {
                pos.method_10100(0, -1, 0);
                state = chunk.method_8320((class_2338)pos);
                if (startedInLiquid || inLiquid || !state.method_51176()) continue;
                inLiquid = true;
                liquidHeight = pos.method_10264();
            }
            int height = pos.method_10264();
            int n = liquidHeight = inLiquid ? liquidHeight : height;
            if (startedInLiquid) {
                pos.method_10103(pos.method_10263(), liquidHeight + 1, pos.method_10260());
                state = chunk.method_8320((class_2338)pos);
                while (state.method_51176() && !chunk.method_31606((class_2338)pos)) {
                    pos.method_10100(0, 1, 0);
                    state = chunk.method_8320((class_2338)pos);
                }
                if (state.method_45474()) {
                    liquidHeight = pos.method_10264() - 1;
                }
            }
            return new Height(height, liquidHeight);
        }
        while (!state.method_45474() && !chunk.method_31606((class_2338)pos)) {
            pos.method_10100(0, 1, 0);
            state = chunk.method_8320((class_2338)pos);
        }
        int height = pos.method_10264() - 1;
        boolean liquid = false;
        while (state.method_51176() && !state.method_45474() && !chunk.method_31606((class_2338)pos)) {
            pos.method_10100(0, 1, 0);
            liquid = true;
            state = chunk.method_8320((class_2338)pos);
        }
        return new Height(height, liquid ? pos.method_10264() - 1 : height);
    }

    public int hashCode() {
        return this.display.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ClaimDisplay) {
            return this.display.equals(((ClaimDisplay)obj).display);
        }
        return false;
    }

    public static class ChunkCache {
        private final Map<class_1923, class_2818> chunkCache = new HashMap<class_1923, class_2818>();
        private final class_3218 level;

        public ChunkCache(class_3218 serverLevel) {
            this.level = serverLevel;
        }

        public class_2818 fetchChunk(int x, int z) {
            class_1923 pos = new class_1923(class_4076.method_18675((int)x), class_4076.method_18675((int)z));
            return this.chunkCache.computeIfAbsent(pos, k -> {
                if (!this.level.method_8393(pos.field_9181, pos.field_9180)) {
                    return null;
                }
                return this.level.method_8497(pos.field_9181, pos.field_9180);
            });
        }
    }

    public record Height(int solid, int water) {
    }

    record DisplayBoxPos(List<class_2338> vertices, List<class_2338> edges) {
    }
}

